<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<div class="container py-5" style="background: linear-gradient(135deg, #87CEEB 0%, #4169E1 100%); min-height: 100vh;">
    <div class="row">
        <div class="col-12">
            <!-- Header Section -->
            <div class="text-center mb-5">
                <div class="d-inline-flex align-items-center justify-content-center bg-white rounded-circle shadow-lg mb-4" style="width: 80px; height: 80px;">
                    <i class="bi bi-code-square text-primary" style="font-size: 2.5rem;"></i>
                </div>
                <h1 class="display-4 fw-bold text-white mb-3">Proyek</h1>
                <p class="lead text-white opacity-90">Koleksi karya dan project yang telah dikerjakan</p>
            </div>

            <!-- Search and Filter Section -->
            <div class="card shadow-lg border-0 mb-5" style="background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px);">
                <div class="card-body">
                    <form method="GET" action="<?= base_url('projects') ?>" class="row g-3">
                        <div class="col-md-3">
                            <label for="search" class="form-label text-primary fw-semibold">
                                <i class="bi bi-search me-2"></i>Cari Proyek
                            </label>
                            <input type="text" class="form-control border-primary" id="search" name="search" 
                                   value="<?= esc($search) ?>" placeholder="Cari nama proyek...">
                        </div>
                        <div class="col-md-2">
                            <label for="jenis_project" class="form-label text-primary fw-semibold">
                                <i class="bi bi-tag me-2"></i>Jenis Proyek
                            </label>
                            <select class="form-select border-primary" id="jenis_project" name="jenis_project">
                                <option value="">Semua</option>
                                <option value="Web" <?= $filter['jenis_project'] === 'Web' ? 'selected' : '' ?>>Web</option>
                                <option value="Mobile" <?= $filter['jenis_project'] === 'Mobile' ? 'selected' : '' ?>>Mobile</option>
                                <option value="Game" <?= $filter['jenis_project'] === 'Game' ? 'selected' : '' ?>>Game</option>
                                <option value="Desktop" <?= $filter['jenis_project'] === 'Desktop' ? 'selected' : '' ?>>Desktop</option>
                                <option value="Lainnya" <?= $filter['jenis_project'] === 'Lainnya' ? 'selected' : '' ?>>Lainnya</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label for="tahun" class="form-label text-primary fw-semibold">
                                <i class="bi bi-calendar me-2"></i>Tahun
                            </label>
                            <input type="number" class="form-control border-primary" id="tahun" name="tahun" 
                                   value="<?= esc($filter['tahun']) ?>" placeholder="Tahun...">
                        </div>
                        <div class="col-md-2">
                            <label for="sort" class="form-label text-primary fw-semibold">
                                <i class="bi bi-sort me-2"></i>Urutkan
                            </label>
                            <select class="form-select border-primary" id="sort" name="sort">
                                <option value="urutan" <?= $sort === 'urutan' ? 'selected' : '' ?>>Urutan</option>
                                <option value="nama_project" <?= $sort === 'nama_project' ? 'selected' : '' ?>>Nama Proyek</option>
                                <option value="jenis_project" <?= $sort === 'jenis_project' ? 'selected' : '' ?>>Jenis Proyek</option>
                                <option value="tahun" <?= $sort === 'tahun' ? 'selected' : '' ?>>Tahun</option>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <label for="order" class="form-label text-primary fw-semibold">
                                <i class="bi bi-arrow-up-down me-2"></i>Order
                            </label>
                            <select class="form-select border-primary" id="order" name="order">
                                <option value="ASC" <?= $order === 'ASC' ? 'selected' : '' ?>>ASC</option>
                                <option value="DESC" <?= $order === 'DESC' ? 'selected' : '' ?>>DESC</option>
                            </select>
                        </div>
                        <div class="col-md-2 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="bi bi-funnel me-1"></i>Filter
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Projects Grid -->
            <?php if (empty($projects)): ?>
                <div class="card shadow-lg border-0 text-center py-5" style="background: rgba(255, 255, 255, 0.95);">
                    <div class="card-body">
                        <i class="bi bi-info-circle text-primary mb-3" style="font-size: 3rem;"></i>
                        <h4 class="text-primary">Tidak ada proyek yang ditemukan</h4>
                        <p class="text-muted">Belum ada data proyek yang tersedia.</p>
                    </div>
                </div>
            <?php else: ?>
                <div class="row g-4">
                    <?php foreach ($projects as $p): ?>
                        <div class="col-lg-4 col-md-6">
                            <div class="card h-100 shadow-lg border-0" style="background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); transition: transform 0.3s ease;">
                                <?php if ($p['foto']): ?>
                                    <?= clickable_image(image_url('projects', $p['foto'], 400, 250), esc($p['nama_project']), 'card-img-top', 'height: 200px; object-fit: cover;') ?>
                                <?php else: ?>
                                    <div class="card-img-top d-flex align-items-center justify-content-center bg-light" style="height: 200px;">
                                        <i class="bi bi-code-square text-primary" style="font-size: 3rem;"></i>
                                    </div>
                                <?php endif; ?>
                                <div class="card-body d-flex flex-column">
                                    <h5 class="card-title text-primary fw-bold mb-3"><?= esc($p['nama_project']) ?></h5>
                                    <div class="mb-3">
                                        <span class="badge bg-primary"><?= esc($p['jenis_project']) ?></span>
                                        <?php if ($p['tahun']): ?>
                                            <span class="badge bg-secondary ms-2"><?= esc($p['tahun']) ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <?php if ($p['teknologi']): ?>
                                        <p class="text-muted mb-2 small">
                                            <i class="bi bi-tools me-1 text-primary"></i><?= esc($p['teknologi']) ?>
                                        </p>
                                    <?php endif; ?>
                                    <?php if ($p['deskripsi']): ?>
                                        <p class="text-muted small flex-grow-1"><?= esc(substr($p['deskripsi'], 0, 100)) ?><?= strlen($p['deskripsi']) > 100 ? '...' : '' ?></p>
                                    <?php endif; ?>
                                    <?php if ($p['link_project']): ?>
                                        <a href="<?= esc($p['link_project']) ?>" target="_blank" class="btn btn-primary w-100 mt-auto">
                                            <i class="bi bi-link-45deg me-1"></i>Lihat Proyek
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <!-- Pagination -->
                <?php if (isset($lastPage) && $lastPage > 1): ?>
                    <div class="row mt-5">
                        <div class="col-12">
                            <nav aria-label="Page navigation">
                                <ul class="pagination justify-content-center">
                                    <?php if ($currentPage > 1): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?= base_url('projects?page=' . ($currentPage - 1) . '&search=' . urlencode($search) . '&jenis_project=' . urlencode($filter['jenis_project']) . '&tahun=' . urlencode($filter['tahun']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                                <i class="bi bi-chevron-left"></i> Sebelumnya
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    
                                    <?php for ($i = 1; $i <= $lastPage; $i++): ?>
                                        <li class="page-item <?= $i == $currentPage ? 'active' : '' ?>">
                                            <a class="page-link" href="<?= base_url('projects?page=' . $i . '&search=' . urlencode($search) . '&jenis_project=' . urlencode($filter['jenis_project']) . '&tahun=' . urlencode($filter['tahun']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                                <?= $i ?>
                                            </a>
                                        </li>
                                    <?php endfor; ?>
                                    
                                    <?php if ($currentPage < $lastPage): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?= base_url('projects?page=' . ($currentPage + 1) . '&search=' . urlencode($search) . '&jenis_project=' . urlencode($filter['jenis_project']) . '&tahun=' . urlencode($filter['tahun']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                                Selanjutnya <i class="bi bi-chevron-right"></i>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </nav>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

